package w83b.w83bUtilidadesComunes;


import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;



/**
 * 
 * @author jroncal
 *
 */
public final class W83bClsConstantes {
	
	/**
	 * 
	 */
	private W83bClsConstantes(){}
	
	//Imagenes
	public static final String CONSTANTE_LOGO_TECLAS="teclas.gif";
	public static final String CONSTANTE_LOGO_GV="logo_gobierno_vasco.gif";
	public static final String CONSTANTE_ESCUDO="escudo.gif";
	
    //Constantes del contexto
    public static final String CONSTANTE_CONTEXTO_IDIOMA="w83bCgaIdioma";
    public static final String CONSTANTE_CONTEXTO_USUARIO="w83bUsuarioXLNets";
    public static final String CONSTANTE_MENSAJES_APLICACION_NO_ERROR="w83bmensajesAplicacionnoError";
    
    //Constantes para campos nulos
	public final static String NULL_DOUBLE = "NULL_DOUBLE";
	public final static String NULL_STRING = "NULL_STRING";
	public final static String NULL_INTEGER = "NULL_INTEGER";
	public final static String NULL_FLOAT = "NULL_FLOAT";
	public final static String NULL_DATE = "NULL_DATE";
	public final static String NULL_BLOB = "NULL_BLOB";

	//Constantes para tipo de datos
	public final static String CONSTANTE_DATO_STRING = "STRING";
	public final static String CONSTANTE_DATO_DATE = "DATE";
	public final static String CONSTANTE_DESCONOCIDO = "DESCONOCIDO";	

	/** The Constant VACIO. */
	public static final String VACIO= "";

	//Constantes Idioma
	public static final String CONSTANTE_CASTELLANO = "es";
	public static final String CONSTANTE_EUSKARA = "eu";
	public static final String CONSTANTE_INGLES = "en";
	public static final String CONSTANTE_IDIOMA_CONVENIADAS = "1";
	public static final String CONSTANTE_BILINGUE = "bi";
	public static final String CONSTANTE_CASTELLANO_XLNETS = "1";
	public static final String CONSTANTE_EUSKARA_XLNETS = "3";


	//Constante String para la fecha
	public static final String FORMATO_FECHA_CASTELLANO="DD/mm/YYYY";
	public static final String FORMATO_FECHA_EUSKARA="YYYY/mm/DD";
	public static final String FORMATO_FECHA="YYYYmmDD";
	public static final String FORMATO_FECHA_COMPLETA_CASTELLANO="DD/mm/YYYY HH24:MI:SS";
	public static final String FORMATO_FECHA_COMPLETA_EUSKARA="YYYY/mm/DD HH24:MI:SS";

	public static final String FORMATO_FECHA_CASTELLANO_PARSER="dd/MM/yyyy";
	public static final String FORMATO_FECHA_EUSKARA_PARSER="yyyy/MM/dd";
	public static final String FORMATO_FECHA_PARSER="yyyymmdd";
	public static final String FORMATO_FECHA_COMPLETA_CASTELLANO_PARSER="dd/MM/yyyy hh:mm:ss";
	public static final String FORMATO_FECHA_COMPLETA_EUSKARA_PARSER="yyyy/MM/dd hh:mm:ss";
	
	public static final String FORMATO_HORA="hh24:mI:ss";
	//Contantes generales
	public static final String CONSTANTE_SI="S";
	public static final String CONSTANTE_NO="N";
	
	//Modos de pantalla
	public static final String MODO_ALTA="A";
	public static final String MODO_EDICION="E";
	public static final String MODO_BUSQUEDA="B";
	public static final String MODO_BUSQUEDA_CONBUSQ_INICIAL="B_I";
	
	//VARIABLES DE LA REQUEST RIA
	public static final String RIA_PAGINA_ACTUAL = "page";
	public static final String RIA_FILAS_PAGINA = "rows";
	public static final String RIA_IDCOLUMNAORDENAR = "sidx";
	public static final String RIA_DIRECCIONORDENACION = "sord";
	public static final String RIA_SEARCH = "_search";
	
	//VARIABLES ALTA/BAJA REGISTRO BD
	public static final String ALTA="A";
	public static final String BAJA="B";
	
	//ELECCION PARCIAL / GLOBAL
	public static final String CONSTANTE_ELECCION_PARCIAL = "P";
	public static final String CONSTANTE_ELECCION_GLOBAL = "G";
	
	//COD COLEGIO
	public static final String CONSTANTE_ESPECIALISTAS_NOCUALIFICADOS = "E";
	public static final String CONSTANTE_TECNICOS_ADMINISTRATIVOS = "T";
	
	public static final String CONSTANTE_DESCRIP_ESPECIALISTAS = "ESP";
	public static final String CONSTANTE_DESCRIP_TECNICOS = "TEC";
	
	public static final String CONSTANTE_ESPECIALISTAS_NOCUALIFICADOS_NUM = "1";
	public static final String CONSTANTE_TECNICOS_ADMINISTRATIVOS_NUM = "0";
	
	
	
	//CDIGOS PROVINCIAS CAV	
	public static final String CONSTANTE_ALAVA = "01";
	public static final String CONSTANTE_BIZKAIA = "48";
	public static final String CONSTANTE_GIPUZKOA = "20";
	public static final String CONSTANTE_SERVICIOS_CENTRALES = "99";
	public static final String CONSTANTE_CAV = "16";
	public static final String[] LISTADO_PROVINCIAS_W83B = new String[]{
		CONSTANTE_ALAVA,CONSTANTE_GIPUZKOA,
		CONSTANTE_BIZKAIA,CONSTANTE_BIZKAIA
};
	
	//CDIGOS CAPITALES
	public static final String CONSTANTE_VITORIA = "059";
	public static final String CONSTANTE_BILBAO = "020";
	public static final String CONSTANTE_DONOSTIA = "069";
	
	//CONSTANTE FASE - PREAVISO
	public static final String CONSTANTE_FASE_PREAVISO = "1";
	
	//PERMISOS VIEJOS
	public static final String CONSTANTE_PERMISO_DELEGACION_ALAVA = "W83B-PF-0001";
	public static final String CONSTANTE_PERMISO_DELEGACION_BIZKAIA = "W83B-PF-0048";
	public static final String CONSTANTE_PERMISO_DELEGACION_GIPUZKOA = "W83B-PF-0020";
	public static final String CONSTANTE_PERMISO_SERVICIOS_CENTRALES = "W83B-PF-0099";
	//fin PERMISOS VIEJOS
	
	//PERMISOS
	public static final String CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES = "W83B-PF-0003";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA = "W83B-PF-0004";
	public static final String CONSTANTE_PERMISO_CONSULTA_ALAVA = "W83B-PF-0005";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA = "W83B-PF-0006";
	public static final String CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA = "W83B-PF-0007";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA = "W83B-PF-0008";
	public static final String CONSTANTE_PERMISO_CONSULTA_BIZKAIA = "W83B-PF-0009";
	
	public static final String PERMISO_ADMINISTRADOR = "1";
	public static final String PERMISO_CONSULTA = "2";
	
	public static final String CONSTANTE_DESCARTADA = "2";
	public static final String CONSTANTE_VALIDADA = "1";
	public static final String CONSTANTE_NO_VALIDADA = "0";
	
	public static final String CONSTANTE_SINUMERO = "1";
	public static final String CONSTANTE_NONUMERO = "0";
	
	//FASES
	public static final String FASE_TRAMITACION_PREAVISO = "1";
	public static final String FASE_TRAMITACION_RECPECION_ACTAS = "2";
	public static final String FASE_TRAMITACION_ACEPTACION_ACTAS= "3";
	public static final String FASE_CIERRE_MENSUAL = "4";
	public static final String FASE_IMPUGNACION = "5";
	public static final String FASE_INCIDENCIAS = "6";
	
	//FASES Y TRAMITES DE ACTAS
	public static final String FASE_ACTA = "2";
	public static final String TRAMITE_ACTA_ALTA = "1";
	public static final String TRAMITE_SINESPECIFICAR = "99";
	public static final String TRAMITE_ACTA_EDICION = "5";
	
	//TRAMITES	
	public static final String TRAMITE_RECEPCION_PREAVISO_E_INICIACION_EXPED = "1";
	public static final String TRAMITE_COMUNIC_SINDICATOS = "2";
	public static final String TRAMITE_NOTIFICACION_PREAVISO_EMPRESA = "3";
	public static final String TRAMITE_RECEPCION_SOLICITUD = "4";
	public static final String TRAMITE_CIERRE_MENSUAL = "1";
	
	//TRAMITES IMPUGNACIONES	
	public static final String TRAMITE_RECEPCION_IMPUGNACION = "1";
	public static final String TRAMITE_COMUNIC_RECEPCION_IMPUGNACION = "2";
	public static final String TRAMITE_CITACION_ARBITRAL = "3";
	public static final String TRAMITE_RESOLUCION_LAUDO = "4";
	public static final String TRAMITE_NOTIFICACION_RESOLUCION_LAUDO = "5";
	
	//FASES Y TRAMITES DE INCIDENCIA
	public static final String TRAMITE_INCIDENCIA_RECEPCION = "1";
	public static final String TRAMITE_INCIDENCIA_MODIFICACION_ACTA = "2";
	
	
	//TIPOS INCIDENCIA
	public static final String CONSTANTE_SUSTITUCION = "1";
	public static final String CONSTANTE_DIMISION = "2";
	public static final String CONSTANTE_BAJA = "3";
	public static final String CONSTANTE_FALLECIMIENTO = "4";
	public static final String CONSTANTE_REVOCACION = "5";
	public static final String CONSTANTE_ACTA_PARCIAL = "6";
	public static final String CONSTANTE_SUBSANACION = "7";
	public static final String CONSTANTE_OTROS_TIPOS_INCIDENCIA = "99";
	
	//CDIGOS BAJA
	public static final String CONSTANTE_MOTIVO_BAJA_ANULACION_ACTA_FECHAELECCION = "90";
	

	public static List LISTADO_PERMISOS_W83B = null;
	
	public static void inicLISTADO_PERMISOS_W83B(){
		if(null==LISTADO_PERMISOS_W83B){
			LISTADO_PERMISOS_W83B = new ArrayList();
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_CONSULTA_ALAVA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_CONSULTA_BIZKAIA);
			LISTADO_PERMISOS_W83B.add(CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES);
		}
	}

	
	
	//TIPO DE ACTA
	public static String TIPO_ACTA_PARCIALES = "P";
	public static String TIPO_ACTA_TOTALES = "T";
	public static String INSPECCIONADA = "1";
	public static String NO_INSPECCIONADA = "0";
	
	//CDIGOS CIF/NIF/OTROS
	public static final String CONSTANTE_CIF = "0";
	public static final String CONSTANTE_NIF = "1";
	public static final String CONSTANTE_OTROS = "2";
	
	public static final String CONSTANTE_ADMON = "A";
	public static final String CONSTANTE_EMPRESA = "E";
	
	//TIPO CONVENIO
	public static final String CONVENIO_ADMINISTRACION="A";
	public static final String CONVENIO_OTRO="O";
	
	public static final String IDIOMA_SESION="es";
	
	//TIPO REGISTRO JURDICO
	public static final String REGISTRO_JURIDICO_PERSONAL = "1";
	public static final String REGISTRO_JURIDICO_OTROS = "2";
	
	//SEXO
	public static final String CONSTANTE_VARON = "H";
	public static final String CONSTANTE_MUJER = "M";
	
	//LIBRO REGISTRO
	/** The Constant SENTIDO_ENTRADA. */
	public static final String SENTIDO_ENTRADA="E";
	
	/** The Constant SENTIDO_SALIDA. */
	public static final String SENTIDO_SALIDA="S";
	
	/** The Constant ENTORNO_EXTERNO. */
	public static final String ENTORNO_EXTERNO="E";
	
	/** The Constant ENTORNO_INTERNO. */
	public static final String ENTORNO_INTERNO="I";	
	
	/** Constantes observaciones Libro de registro. */
	public static final String OBS_REG_NOTIF_ELEMENTOS_LOTE ="Solicitud de inscripcin de ficheros";
	 
	public static final String VERSION_PRIMERA ="0";
	
	public static final String ELA = "ELA";
	public static final String CCOO = "CCOO";
	public static final String UGT = "UGT";
	public static final String LAB = "LAB";
	public static final String USO = "USO";
	public static final String CUIS = "CUIS";
	public static final String CTI = "CTI";
	public static final String CSI = "CSI";
	public static final String NOSIN = "NOSIN";
	
	private static String codELAtemp = null;
	private static String codCCOOtemp = null;
	private static String codUGTtemp = null;
	private static String codLABtemp = null;
	private static String codUSOtemp = null;
	private static String codCUIStemp = null;
	private static String codCTItemp = null;
	private static String codCSItemp = null;
	private static String codNOSINtemp = null;

	public static String codELA = (codELAtemp==null)?getinic(ELA):codELAtemp;
	public static String codCCOO = (codCCOOtemp==null)?getinic(CCOO):codCCOOtemp;
	public static String codUGT = (codUGTtemp==null)?getinic(UGT):codUGTtemp ;
	public static String codLAB = (codLABtemp==null)?getinic(LAB):codLABtemp;
	public static String codUSO = (codUSOtemp==null)?getinic(USO):codUSOtemp;
	public static String codCUIS = (codCUIStemp==null)?getinic(CUIS):codCUIStemp;
	public static String codCTI = (codCTItemp==null)?getinic(CTI):codCTItemp;
	public static String codCSI = (codCSItemp==null)?getinic(CSI):codCSItemp;
	public static String codNOSIN = (codNOSINtemp==null)?getinic(NOSIN):codNOSINtemp;
	public static String Fimpugmax = getFimpugmax();
	public static String CALENDARIO_ARABA = "cal-vi";
	public static String CALENDARIO_BIZKAIA = "cal-bi";
	public static String CALENDARIO_GIPUZKOA = "cal-ss";
	public static String CALENDARIO_DIAS_HABILES = "5";
	
	public static String CONSTANTE_HISTORIAL_MODO_LECTURA = "L";
	public static String CONSTANTE_HISTORIAL_MODO_ESCRITURA = "E";
	public static String CONSTANTE_HISTORIAL_MODO_ACTUALIZACION = "A";
	public static String CONSTANTE_HISTORIAL_MODO_BORRADO = "B";
	
	public static String CONSTANTE_DELEGADO = "D";
	public static String CONSTANTE_RESPONSABLE = "R";
	public static String CONSTANTE_SECRETARIO = "S";
	
	public static String CTE_DELEGADO = "1";
	public static String CTE_RESPONSABLE = "2";
	public static String CTE_SECRETARIO = "3";
	public static String CTE_DIRECTOR = "4";
	
	//COD CAMPO ACTAS 65
	public static String convenio = "1";
	public static String preaviso = "2";
	public static String ctoTrabajo = "3";
	public static String fechaEntrada = "4";
	public static String fechaEleccion = "5";
	public static String totDelegados = "6";
	public static String totElectores = "7";
	public static String ctosHombres = "8";
	public static String ctosMujeres = "9";
	public static String actaTotalNum = "10";
	public static String numRegES = "11";
	public static String fechaRegES = "12";
	public static String fechaComision = "13";
	public static String delegadosHombres = "14";
	public static String delegadosMujeres = "15";
	public static String electoresHombres = "16";
	public static String electoresMujeres = "17";
	public static String observaciones = "18";
	public static String inspeccionada = "19";
	public static String maxDelegados = "20";
	public static String remitente = "21";
	public static String escrutinioSindicatoTA = "22";
	public static String escrutinioSindicatoENC = "23";
	public static String difSindicatoTA = "24";
	public static String difSindicatoENC = "25";
	public static String papeletasValidasTA = "26";
	public static String papeletasNulasTA = "27";
	public static String papeletasBlancasTA = "28";
	public static String electoresTA = "29";
	public static String votantesTA = "30";
	public static String papeletasValidasENC = "31";
	public static String papeletasNulasENC = "32";
	public static String papeletasBlancasENC = "33";
	public static String electoresENC = "34";
	public static String votantesENC = "35";
	public static String docAdjuntos = "36";
	public static String delegado = "37";
	//FIN COD CAMPO ACTAS 65
	
	public static String fechaMigracion = "201210";//ano-mes
	public static String anyoMigracion = "2012";//ano
	public static String mesMigracion = "10";//mes (sin 0 por delante si es de 1 digito)
	
		public static String CONSTANTE_EMP = "E";
	public static String CONSTANTE_CENTRO = "C";
	
	public static String CONSTANTE_INDTIPCENTRO = "1";
	
	//PLANTILLAS
	public static String COMUNICACION_SINDICATOS_PREAVISO = "ComEntradaPreav.rtf";
	public static String NOTIFICACION_EMPRESA_PREAVISO = "ComEntradaPreav.rtf";
	public static String COMUNICACION_SINDICATOS_ACTAS = "ComEntradaActas.rtf";
	public static String COMUNICACION_REQUERIMIENTO = "ComunRequerim.rtf";
	public static String OFICINA_REQUERIMIENTO = "OficRequerim.rtf";
	public static String NOTIFICACION_EMPRESA_ACTA = "ComEntradaActas.rtf";
	public static String COMUNICACION_RECEPCION_IMPUGNACION = "ComunImpugn.rtf";
	public static String NOTIFICACION_CITACION = "Citacion.rtf";
	public static String COMUNICACION_LAUDO = "ComunLaudo.rtf";
	public static String ACUSES = "PlantillaAcuses.rtf";
	public static String ETIQUETAS = "Etiquetas.rtf";
	public static String ETIQUETAS_CARPETAS = "EtiquetasCarpetas.rtf";
	public static String CARTAS = "CARTAS.rtf";
	public static String CERTIFICADO_EMPRESA = "CERTEMPR.RTF";
	public static String CERTIFICADO_CENTRALES_SINDICALES_CONVENIO = "CertSindConv.RTF";
	public static String CERTIFICADO_COMPOSICIN_RGANO_REPRESENTACIN = "CERTORGREPRES.RTF";
	public static String CERTIFICADO_REPRESENTACIN_SINDICAL_SECTORES_NEGOCIACION_COLECTIVA = "CertSindSectNegCol.rtf";
	public static String CERTIFICADO_NMERO_DELEGADOS_CENTRAL_SINDICAL = "CERTDELSIND.RTF";
	public static String CERTIFICADO_RESULTADOS_CENTRAL_SINDICAL = "CertSind.rtf";
	public static String CERTIFICADO_NEGATIVO_CONVOCATORIA_ELECCIONES = "CERTNEGCONVELEC.RTF";
	public static String CERTIFICADO_NEGATIVO_REPRESENTATIVIDAD = "CERTNEGREPRES.RTF";	
	public static String CERTIFICADO_MAS_REPRESENTATIVIDAD = "CERTMASREPRESENT.RTF";	
	public static String RELACUSES = "RelAcuse.rtf";
	public static String COMUNICACION_COMUNICACION_INCIDENCIAS = "ComIncidencias.rtf";
	//FIN PLANTILLAS
	
	  /** The Constant correspondeciaColumnas. */
    public final static HashMap correspondeciaNumeroColumnas =  new HashMap();
    static
    	{
    	correspondeciaNumeroColumnas.put("0",  "A");
    	correspondeciaNumeroColumnas.put("1",  "B");
    	correspondeciaNumeroColumnas.put("2",  "C");
    	correspondeciaNumeroColumnas.put("3",  "D");
    	correspondeciaNumeroColumnas.put("4",  "E");
    	correspondeciaNumeroColumnas.put("5",  "F");
    	correspondeciaNumeroColumnas.put("6",  "G");
    	correspondeciaNumeroColumnas.put("7",  "H");
    	correspondeciaNumeroColumnas.put("8",  "I");
    	correspondeciaNumeroColumnas.put("9",  "J");
    	correspondeciaNumeroColumnas.put("10", "K");
    	correspondeciaNumeroColumnas.put("11", "L");
    	correspondeciaNumeroColumnas.put("12", "M");
    	correspondeciaNumeroColumnas.put("13", "N");
    	correspondeciaNumeroColumnas.put("14", "O");
    	correspondeciaNumeroColumnas.put("15", "P");
    	correspondeciaNumeroColumnas.put("16", "Q");
    	correspondeciaNumeroColumnas.put("17", "R");
    	correspondeciaNumeroColumnas.put("18", "S");
    	correspondeciaNumeroColumnas.put("19", "T");
    	correspondeciaNumeroColumnas.put("20", "U");
    	correspondeciaNumeroColumnas.put("21", "V");
    	correspondeciaNumeroColumnas.put("22", "W");
    	correspondeciaNumeroColumnas.put("23", "X");
    	correspondeciaNumeroColumnas.put("24", "Y");
    	correspondeciaNumeroColumnas.put("25", "Z");
    	
    	}
	

	public static String getinic(String nomsindicato){		
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder docBuilder=null;
		try {
			docBuilder = docBuilderFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
		
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		Document doc=null;
		try {
			InputStream input = W83bClsConstantes.class.getResourceAsStream("/html/datos/xml/w83bDatosComunes.xml");
			doc = (Document)docBuilder.parse(input);
		} catch (SAXException e) {
		
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		} catch (IOException e) {
			
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		String querie;
		NodeList nodeNOMBRE=null;
		try {
			querie = "//parent::XML/SINDICATOS/"+ELA+"/text()";
			codELAtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CCOO+"/text()";
			codCCOOtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+UGT+"/text()";
			codUGTtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+LAB+"/text()";
			codLABtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+USO+"/text()";
			codUSOtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CUIS+"/text()";
			codCUIStemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CTI+"/text()";
			codCTItemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CSI+"/text()";
			codCSItemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+NOSIN+"/text()";
			codNOSINtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+nomsindicato+"/text()";
			nodeNOMBRE = XPathAPI.selectNodeList(doc, querie);
		} catch (TransformerException e) {
			
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return nodeNOMBRE.item(0).getNodeValue();
	}
	public static String getFimpugmax(){		
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder docBuilder=null;
		try {
			docBuilder = docBuilderFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
		
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		Document doc=null;
		try {
			InputStream input = W83bClsConstantes.class.getResourceAsStream("/html/datos/xml/w83bDatosComunes.xml");
			doc = (Document)docBuilder.parse(input);
		} catch (SAXException e) {
		
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		} catch (IOException e) {
			
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		String querie;
		NodeList nodeNOMBRE=null;
		try {
			querie = "//parent::XML/NUMDIASIMPUG/text()";
			nodeNOMBRE = XPathAPI.selectNodeList(doc, querie);
		} catch (TransformerException e) {
			
			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return nodeNOMBRE.item(0).getNodeValue();
	}
	 //Numeros
    /** The Constant ZERO. */
    public static final int ZERO = 0;
    
    /** The Constant UNO. */
    public static final int UNO = 1;
    
    /** The Constant DOS. */
    public static final int DOS = 2;
    
    /** The Constant DOSYMEDIO. */
    public static final double DOSYMEDIO = 2.5;
    
    /** The Constant TRES. */
    public static final int TRES = 3;
    
    /** The Constant CUATRO. */
    public static final int CUATRO = 4;
    
    /** The Constant CUATROYMEDIO. */
    public static final double CUATROYMEDIO = 4.5;
    
    /** The Constant SIETEYMEDIO. */
    public static final double SIETEYMEDIO = 7.5;
    
    /** The Constant CINCO. */
    public static final int CINCO = 5;
    
    /** The Constant SEIS. */
    public static final int SEIS = 6;
    
    /** The Constant SIETE. */
    public static final int SIETE = 7;
    
    /** The Constant OCHO. */
    public static final int OCHO = 8;
    
    /** The Constant NUEVE. */
    public static final int NUEVE = 9;
    
    /** The Constant DIEZ. */
    public static final int DIEZ = 10;
    
    /** The Constant ONCE. */
    public static final int ONCE = 11;
    
    /** The Constant DOCE. */
    public static final int DOCE = 12;
    
    /** The Constant TRECE. */
    public static final int TRECE = 13;
    
    /** The Constant CATORCE. */
    public static final int CATORCE = 14;
    
    /** The Constant QUINCE. */
    public static final int QUINCE = 15;
    
    /** The Constant DIECISEIS. */
    public static final int DIECISEIS = 16;
    
    /** The Constant DIECISIETE. */
    public static final int DIECISIETE = 17;
    
    /** The Constant DIECIOCHO. */
    public static final int DIECIOCHO = 18;
    
    /** The Constant DIEZYNUEVE. */
    public static final int DIEZYNUEVE = 19;
    
    /** The Constant VEINTE. */
    public static final int VEINTE = 20;
    
    /** The Constant VEINTIUNA. */
    public static final int VEINTIUNA = 21;
    
    /** The Constant VEINTIDOS. */
    public static final int VEINTIDOS = 22;
    
    /** The Constant VEINTITRES. */
    public static final int VEINTITRES = 23;
    
    /** The Constant VEINTICINCO. */
    public static final int VEINTICINCO = 25;
    
    /** The Constant VEINTISEIS. */
    public static final int VEINTISEIS = 26;
    
    /** The Constant VEINTICUATRO. */
    public static final int VEINTICUATRO = 24;
    
    /** The Constant VEINTISIETE. */
    public static final int VEINTISIETE = 27;
    
    /** The Constant VEINTIOCHO. */
    public static final int VEINTIOCHO = 28;
    
    /** The Constant VEINTINUEVE. */
    public static final int VEINTINUEVE = 29;
    
    /** The Constant TREINTA. */
    public static final int TREINTA = 30;
    
    /** The Constant TREINTAYUNO. */
    public static final int TREINTAYUNO = 31;
    
    /** The Constant TREINTAYDOS. */
    public static final int TREINTAYDOS = 32;
    
    /** The Constant TREINTAYTRES. */
    public static final int TREINTAYTRES = 33;
    
    /** The Constant TREINTAYCUATRO. */
    public static final int TREINTAYCUATRO = 34;
    
    /** The Constant TREINTAYCINCO. */
    public static final int TREINTAYCINCO = 35;
    
    /** The Constant TREINTAYSEIS. */
    public static final int TREINTAYSEIS = 36;
    
    /** The Constant TREINTAYSIETE. */
    public static final int TREINTAYSIETE = 37;
    
    /** The Constant TREINTAYOCHO. */
    public static final int TREINTAYOCHO = 38;
    
    /** The Constant TREINTAYNUEVE. */
    public static final int TREINTAYNUEVE = 39;
    
    /** The Constant CUARENTA. */
    public static final int CUARENTA = 40;
    
    /** The Constant NOVENTAYNUEVE. */
    public static final int NOVENTAYNUEVE = 99;
    
    public static final int TRESCIENTOS = 300;
    
    public static final String TIPOPREAVISOVUELTA = "V";
    
    public static final String TIPOPREAVISOIDA = "I";
    
    //NOTIFICACIONES
    public static final String ETIQUETADOCUMENTO ="ejgvDocument";
	public static final String ETIQUETATEXTOAFIRMAR ="ejgvSignedInfo";
	public static final String ETIQUETAFIRMAINICIO ="ejgvSignatureFooterBegin";
	public static final String ETIQUETAFIRMAFIN ="ejgvSignatureFooterEnd";
	public static final String IDA = "0";
	public static final String ENTRADA ="E";
	public static final String SALIDA ="S";
	public static final String PREFIJO_FICHERO_VUELTA="preavisoEJ";
	
	public static final String tipoPreavisoPreav = "0";
	public static final String tipoPreavisoBandeja = "1";
	
	public static final String  VARIOS_SINDICATOS_PROMOTORES = "999";
	public static final int  	ID_REMESA_ERROR = 0;
	
	//ENVIO A CORRESPONDENCIA
	public static final String  TIPOREMESA_DIARIA = "D";
	public static final String  TIPOREMESA_MASIVA = "M";
	public static final String  ENVIO_TODOS= "T";
	public static final String  ENVIO_PENDIENTES="P";
	
	//DESTINATARIOS COMUNICACIN LAUDO
	public static final String DESTINATARIO_LAUDO_CENTRO = "C";
	public static final String DESTINATARIO_LAUDO_PRESIDENTE = "P";
	
	
}